/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.quests.adapters;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import dev.toma.gunsrpg.common.quests.quest.area.IMobSpawnProcessor;
import dev.toma.gunsrpg.common.quests.quest.area.IMobSpawnProcessorSerializer;
import dev.toma.gunsrpg.common.quests.quest.area.IMobSpawner;
import dev.toma.gunsrpg.common.quests.quest.area.MobSpawnProcessorType;
import dev.toma.gunsrpg.common.quests.quest.area.MobSpawner;
import dev.toma.gunsrpg.util.helper.JsonHelper;
import java.util.List;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public final class MobSpawnerAdapter {
    public IMobSpawner deserialize(JsonElement json) throws JsonParseException {
        JsonObject object = JsonHelper.asJsonObject(json);
        ResourceLocation entityId = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)object, (String)"entity"));
        EntityType<? extends LivingEntity> entityType = MobSpawnerAdapter.tryParseAsLivingEntity(entityId);
        int weight = JsonHelper.getAsBoundedInt(object, "weight", 1, 1, Integer.MAX_VALUE);
        int minCount = JsonHelper.getAsBoundedInt(object, "minCount", 1, 1, 64);
        int maxCount = JsonHelper.getAsBoundedInt(object, "maxCount", 1, 1, 64);
        List<IMobSpawnProcessor> processors = JsonHelper.deserializeAsList("processors", object, MobSpawnerAdapter::resolveSpawnProcessor);
        return new MobSpawner(entityType, weight, minCount, maxCount, processors);
    }

    public static <P extends IMobSpawnProcessor> P resolveSpawnProcessor(JsonElement element) throws JsonParseException {
        JsonObject object = JsonHelper.asJsonObject(element);
        ResourceLocation id = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)object, (String)"type"));
        MobSpawnProcessorType type = MobSpawnProcessorType.findById(id);
        if (type == null) {
            throw new JsonSyntaxException("Unknown spawn processor: " + id);
        }
        IMobSpawnProcessorSerializer serializer = type.getSerializer();
        return serializer.deserialize(type, (JsonElement)object);
    }

    public static EntityType<? extends LivingEntity> tryParseAsLivingEntity(ResourceLocation location) throws JsonParseException {
        EntityType type = (EntityType)ForgeRegistries.ENTITIES.getValue(location);
        if (type == null) {
            throw new JsonSyntaxException("Unknown entity: " + location);
        }
        try {
            return type;
        }
        catch (ClassCastException e) {
            throw new JsonSyntaxException("Not a living entity: " + location);
        }
    }
}

